(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35738,        967]
NotebookOptionsPosition[     33165,        888]
NotebookOutlinePosition[     33515,        903]
CellTagsIndexPosition[     33472,        900]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Schmidt-Cassegrain Telescope with a corrector after the Cassegrain combination\
\>", "Title",
 CellChangeTimes->{{3.677850420153714*^9, 3.6778504469537516`*^9}}],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["SchmidtCassegrainCAfter",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["ft",
           FontWeight->Bold], Cell["total focal length"]},
         {Cell["em",
           FontWeight->Bold], Cell["back distance"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["SchmidtCassegrainCAfterInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Schmidt-Cassegrain Telescope with a corrector after the Cassegrain combination\
\>", "Title",
 CellChangeTimes->{{3.677850420153714*^9, 3.6778504469537516`*^9}}],

Cell[TextData[StyleBox["Owing to the complexity of the general formulae, we \
consider the design relative to a given Cassegrain combination. We can not \
eliminate spherical aberration and coma, since the astigmatism is too high. \
We have to eliminate all these aberrations.",
 FontSize->18]], "Text",
 CellChangeTimes->{{3.4255237369375*^9, 3.4255237823125*^9}, {
   3.425884163953125*^9, 3.42588416515625*^9}, {3.42616336684375*^9, 
   3.426163382765625*^9}, {3.426317238140625*^9, 3.4263172385*^9}, {
   3.426317274515625*^9, 3.426317320703125*^9}, {3.426317425359375*^9, 
   3.4263175460625*^9}, 3.4263176216875*^9}],

Cell["\<\
Spherical aberration, coma, and axial chromatism (the variable Rc, K1, a4, \
as, \[Lambda]1, \[Lambda]2, \[Lambda]3 have to be unassigned, for that we use \
Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "Rc", ",", "K1", ",", "a4", ",", "as", ",", "\[Lambda]1", ",", 
    "\[Lambda]2", ",", "\[Lambda]3"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "800"}], ",", 
      RowBox[{"-", "250"}], ",", "Infinity", ",", "Rc"}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "300"}], ",", "300", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.518722", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.522376", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.514322", ",", "1"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"K1", ",", "0", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "as"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "100", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "0.3", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.425885567390625*^9, 3.4258855810625*^9}, {
  3.426163194*^9, 3.426163246296875*^9}, {3.426180796765625*^9, 
  3.426180798890625*^9}, {3.6778505430119033`*^9, 3.6778505522510176`*^9}}],

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{"Simplify", "[", "GOComaCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
  3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
  3.42618080365625*^9}, {3.677850554761021*^9, 3.6778505589010267`*^9}}],

Cell["\<\
The radius Rc is determined imposing the condition of axial chromatism\
\>", "Text",
 CellChangeTimes->{
  3.4261825638125*^9, {3.42631757609375*^9, 3.42631759084375*^9}, {
   3.42631767140625*^9, 3.42631769721875*^9}},
 FontFamily->"Times New Roman",
 FontSize->18,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"eq4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "GOn"}], "]"}], "]"}], "-", 
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "GOn"}], "]"}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.426180711484375*^9, 3.426180738171875*^9}, {
  3.426180811890625*^9, 3.426180814796875*^9}, {3.6778505673210387`*^9, 
  3.677850588081068*^9}}],

Cell["\<\
The spherical aberration, coma, and axial chromatism vanish if\
\>", "Text",
 CellChangeTimes->{
  3.4261825638125*^9, {3.42631757609375*^9, 3.42631759084375*^9}, {
   3.42631767140625*^9, 3.4263177361875*^9}, 3.438929382046875*^9},
 FontFamily->"Times New Roman",
 FontSize->18,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{"s2", "=", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Quiet", "@", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eq1", "\[Equal]", "0"}], ",", 
        RowBox[{"eq2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq4", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a4", ",", "K1", ",", "Rc"}], "}"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.4261815533125*^9, 3.42618156634375*^9}, {
  3.6778505956010785`*^9, 3.677850613691104*^9}}],

Cell["The aberrations and the total focal length are", "Text",
 CellChangeTimes->{
  3.4261825638125*^9, {3.42631757609375*^9, 3.42631759084375*^9}, {
   3.42631767140625*^9, 3.426317780078125*^9}, {3.438929531984375*^9, 
   3.4389295353125*^9}},
 FontFamily->"Times New Roman",
 FontSize->18,
 FontWeight->"Plain"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOaberration", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s2"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOcoma", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s2"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.67785063949114*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOastigmatism", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s2"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850651711157*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOcurvature", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s2"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850662411172*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "GOn"}], "]"}], "]"}], "-", 
    RowBox[{"GOdistancegauss", 
     StyleBox["[",
      FontWeight->"Plain"], 
     RowBox[{"[", 
      RowBox[{"3", ",", "GOn"}], "]"}], "]"}]}], ")"}], "/.", "s2"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850686561206*^9}, {3.6778507178912497`*^9, 
   3.677850721001254*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOfocalLength", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s2"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850686561206*^9}, {3.677850727691263*^9, 
   3.6778507316212687`*^9}}],

Cell["Spherical aberration, coma, astigmatism and axial chromatism", "Text",
 CellChangeTimes->{
  3.4261825638125*^9, {3.42631757609375*^9, 3.42631759084375*^9}, {
   3.42631780615625*^9, 3.426317837296875*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "Rc", ",", "K1", ",", "K2", ",", "a4", ",", "as", ",", "\[Lambda]1", ",", 
    "\[Lambda]2", ",", "\[Lambda]3"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "800"}], ",", 
      RowBox[{"-", "250"}], ",", "Infinity", ",", "Rc"}], "}"}]}], ";"}], 
  " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "300"}], ",", "300", ",", "5"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.518722", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.522376", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1", ",", "1.514322", ",", "1"}], "}"}]}], 
    "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"K1", ",", "K2", ",", "0", ",", 
     RowBox[{"{", 
      RowBox[{"a4", ",", "as"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "100", ",", "0", ",", 
   "0", ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "0.3", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}], ",", 
   " ", 
   RowBox[{"OutputLevel", "\[Rule]", "\"\<Coefficients\>\""}], ",", " ", 
   RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{"eq1", "=", 
  RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eq2", "=", 
  RowBox[{"Simplify", "[", "GOComaCoefficient", "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"eq3", "=", 
  RowBox[{"Simplify", "[", "GOAstigmatismCoefficient", "]"}]}]], "Input",
 CellChangeTimes->{{3.677850802221368*^9, 3.6778508122413816`*^9}}],

Cell[BoxData[
 RowBox[{"eq4", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "GOn"}], "]"}], "]"}], "-", 
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"3", ",", "GOn"}], "]"}], "]"}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"s3", "=", 
  RowBox[{"Flatten", "@", 
   RowBox[{"Quiet", "@", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"eq1", "\[Equal]", "0"}], ",", 
        RowBox[{"eq2", "\[Equal]", "0"}], ",", 
        RowBox[{"eq3", "\[Equal]", "0"}], ",", 
        RowBox[{"eq4", "\[Equal]", "0"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a4", ",", "K1", ",", "K2", ",", "Rc"}], "}"}]}], 
     "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.426180791296875*^9, 3.426180793125*^9}, {
  3.42618083234375*^9, 3.42618087678125*^9}, {3.426181724578125*^9, 
  3.426181726484375*^9}, {3.677850842341424*^9, 3.677850846171429*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOaberration", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850630781128*^9}, {3.677850865581456*^9, 
   3.6778508657214565`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOcoma", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.67785063949114*^9}, {3.6778508671114583`*^9, 
   3.6778508673814588`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOastigmatism", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850651711157*^9}, {3.677850868871461*^9, 
   3.6778508691814613`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOcurvature", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850662411172*^9}, {3.677850870371463*^9, 
   3.6778508706814637`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"GOdistancegauss", "[", 
     RowBox[{"[", 
      RowBox[{"2", ",", "GOn"}], "]"}], "]"}], "-", 
    RowBox[{"GOdistancegauss", 
     StyleBox["[",
      FontWeight->"Plain"], 
     RowBox[{"[", 
      RowBox[{"3", ",", "GOn"}], "]"}], "]"}]}], ")"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850686561206*^9}, {3.6778507178912497`*^9, 
   3.677850721001254*^9}, {3.6778508719014654`*^9, 3.6778508723714657`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"GOfocalLength", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", "s3"}]], "Input",
 CellChangeTimes->{{3.425885265390625*^9, 3.42588528984375*^9}, {
   3.42588559240625*^9, 3.425885633453125*^9}, {3.42618080225*^9, 
   3.42618080365625*^9}, 3.42618114721875*^9, {3.42618117934375*^9, 
   3.426181181*^9}, {3.4261812310625*^9, 3.426181265046875*^9}, {
   3.426181328640625*^9, 3.4261813380625*^9}, {3.426181413625*^9, 
   3.426181428*^9}, {3.42618160003125*^9, 3.4261816133125*^9}, {
   3.6778506188611107`*^9, 3.677850686561206*^9}, {3.677850727691263*^9, 
   3.6778507316212687`*^9}, {3.6778508735714674`*^9, 3.677850873921468*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchmidtCassegrainCAfter Examples", "Title",
 CellChangeTimes->{{3.677850420153714*^9, 3.6778504469537516`*^9}, {
  3.6778505181438513`*^9, 3.6778505219338565`*^9}}],

Cell["\<\
To use the SchmidtCassegrainCAfter function you can either use directly the \
function SchmidtCassegrainCAfter[f1, ft, em, diam, \[Theta]] or use the \
interactive panel created by calling the function \
SchmidtCassegrainCAfterInputPanel[].
It let\[CloseCurlyQuote]s you to set input values and then call the \
SchmidtCassegrainCAfter function. Moreover, it helps to load examples from \
the saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Primary mirror F/2.5-Total focal =2000", "Text",
 CellChangeTimes->{
  3.426320716671875*^9, {3.426320771203125*^9, 3.426320795546875*^9}, {
   3.438953565484375*^9, 3.43895356653125*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "500"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.426164081515625*^9, 3.426164094546875*^9}, {
   3.426164134109375*^9, 3.42616413603125*^9}, {3.426164609078125*^9, 
   3.426164609859375*^9}, {3.42616469784375*^9, 3.426164736578125*^9}, 
   3.4261691653125*^9, {3.42616920146875*^9, 3.42616920203125*^9}, 
   3.426169235265625*^9, {3.426182637515625*^9, 3.426182668828125*^9}, 
   3.4264812823125*^9, {3.438954813*^9, 3.4389549001875*^9}, 
   3.438955286203125*^9, 3.6778497930368357`*^9}],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCAfter", "[", 
  RowBox[{
  "f1", ",", " ", "ft", ",", " ", "em", ",", " ", "diam", ",", " ", 
   "\[Theta]"}], "]"}]], "Input",
 CellChangeTimes->{{3.677849789596831*^9, 3.677849804586852*^9}}],

Cell["Primary mirror F/2-Total focal =2000", "Text",
 CellChangeTimes->{
  3.426320716671875*^9, {3.426320771203125*^9, 3.426320808890625*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ft", "=", "2000"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"em", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "0.3"}], ";"}]}], "Input",
 CellChangeTimes->{{3.426164081515625*^9, 3.426164094546875*^9}, {
   3.426164134109375*^9, 3.42616413603125*^9}, {3.426164609078125*^9, 
   3.426164609859375*^9}, {3.42616469784375*^9, 3.426164736578125*^9}, 
   3.4261691653125*^9, {3.42616920146875*^9, 3.42616920203125*^9}, 
   3.426169235265625*^9, {3.426182637515625*^9, 3.426182668828125*^9}, 
   3.4264812823125*^9, {3.438954813*^9, 3.4389549001875*^9}, 
   3.438955225875*^9, 3.438955279140625*^9, 3.677850927041542*^9}],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCAfter", "[", 
  RowBox[{
  "f1", ",", " ", "ft", ",", " ", "em", ",", " ", "diam", ",", " ", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<SchmidtCassegrainCAfter\>\"", 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCAfter", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"SchmidtCassegrainCAfterInputPanel", "[", "]"}]], "Input",
 CellChangeTimes->{{3.677850964191594*^9, 3.6778509662515974`*^9}}]
}, Open  ]]
},
WindowSize->{1904, 992},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"GeometricOptics.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 171, 3, 71, "Title"],
Cell[CellGroupData[{
Cell[763, 29, 35, 0, 43, "Subsection"],
Cell[801, 31, 118, 2, 46, "Text"],
Cell[922, 35, 1495, 40, 261, "Text"],
Cell[2420, 77, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4567, 135, 40, 0, 43, "Subsection"],
Cell[4610, 137, 259, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4906, 148, 40, 0, 43, "Subsection"],
Cell[4949, 150, 111, 2, 46, "Text"],
Cell[5063, 154, 3193, 83, 551, "Text"],
Cell[8259, 239, 2296, 56, 473, "Text"],
Cell[10558, 297, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14072, 392, 171, 3, 71, "Title"],
Cell[14246, 397, 622, 9, 70, "Text"],
Cell[14871, 408, 187, 4, 46, "Text"],
Cell[15061, 414, 1494, 46, 143, "Input"],
Cell[16558, 462, 313, 5, 32, "Input"],
Cell[16874, 469, 307, 5, 32, "Input"],
Cell[17184, 476, 298, 8, 45, "Text"],
Cell[17485, 486, 474, 12, 32, "Input"],
Cell[17962, 500, 311, 8, 45, "Text"],
Cell[18276, 510, 528, 14, 32, "Input"],
Cell[18807, 526, 315, 7, 45, "Text"],
Cell[19125, 535, 114, 3, 32, "Input"],
Cell[19242, 540, 558, 10, 32, "Input"],
Cell[19803, 552, 566, 10, 32, "Input"],
Cell[20372, 564, 564, 10, 32, "Input"],
Cell[20939, 576, 842, 19, 32, "Input"],
Cell[21784, 597, 618, 11, 32, "Input"],
Cell[22405, 610, 212, 3, 46, "Text"],
Cell[22620, 615, 1647, 48, 143, "Input"],
Cell[24270, 665, 107, 2, 32, "Input"],
Cell[24380, 669, 102, 2, 32, "Input"],
Cell[24485, 673, 177, 3, 32, "Input"],
Cell[24665, 678, 308, 9, 32, "Input"],
Cell[24976, 689, 684, 17, 32, "Input"],
Cell[25663, 708, 617, 11, 32, "Input"],
Cell[26283, 721, 612, 11, 32, "Input"],
Cell[26898, 734, 618, 11, 32, "Input"],
Cell[27519, 747, 616, 11, 32, "Input"],
Cell[28138, 760, 892, 19, 32, "Input"],
Cell[29033, 781, 666, 11, 32, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29736, 797, 170, 2, 71, "Title"],
Cell[29909, 801, 479, 9, 94, "Text"],
Cell[30391, 812, 194, 3, 46, "Text"],
Cell[30588, 817, 759, 17, 121, "Input"],
Cell[31350, 836, 235, 5, 32, "Input"],
Cell[31588, 843, 143, 2, 46, "Text"],
Cell[31734, 847, 776, 17, 121, "Input"],
Cell[32513, 866, 169, 4, 32, "Input"],
Cell[32685, 872, 65, 0, 46, "Text"],
Cell[32753, 874, 97, 2, 32, "Input"],
Cell[32853, 878, 71, 1, 32, "Input"],
Cell[32927, 881, 70, 0, 46, "Text"],
Cell[33000, 883, 149, 2, 32, "Input"]
}, Open  ]]
}
]
*)

